//#define CALLBACK_ENABLE

// 
// `֘Ȁt@C
// 

#include "stdinc.h"
#include "syscall.h"
#include "pg.h"
#include "pce.h"
#include "main.h"
#include "string.h"
#include "sound.h"
#include "hue_image.h"

// external
extern int skip_next_frame;
extern EmuConfig eConf;
extern EmuRuntime eRun;

// global
int skip_next_vsync=0;

static void blt_normal(int x,int y,int w,int h);
static void blt_gpu(int x,int y,int w,int h);

// 摜WJ֐|C^
void (*PutImage)(int x,int y,int w,int h) = blt_normal;

// CPU`掞Frame buffer 
PALFMT xbuf1[WIDTH*HEIGHT];
static void *img_buffer[2]={ xbuf1, xbuf1 };


//---------------------------------------------------------------
// PCE.CPutImageŒڌĂ΂B
//---------------------------------------------------------------
void frame_skip(void)
{
//    if(frmcnt==0) {skip_next_frame=1; }
//    frmcnt = (frmcnt+1) % 60;
    
    if( (eConf.skip>>eRun.frame) & 0x01 ) {
        skip_next_frame = 1;
    }

    eRun.frame = (eRun.frame+1) % 4;
}

void dbgCDPlay(void);



void image_flip(void)
{
    // page flip
    if(eConf.vsync){// && !skip_next_vsync) {
        pgWaitV();
    }
    
    pgScreenFlip();
}

// 
void image_debug(void)
{
    // fpsvZ
    static unsigned int  lasttick=0,framerate = 0;
    register DWORD curtick = sceKernelLibcClock();
    int fps;
    
    if(lasttick > curtick) {
        lasttick = curtick;
    }
    
    framerate = (framerate + (curtick-lasttick))/2;
    if(framerate==0) fps = 0;
    else             fps = ((10000000/(framerate))+9)/10;
    lasttick = curtick;

    if(0){
        int f = scePowerGetCpuClockFrequency();
        int b = scePowerGetBusClockFrequency();
        mh_print_dec(0,10,f,RGB_BLUE);
        mh_print_dec(0,20,b,RGB_BLUE);
    }
    
    if(eConf.debug) {
        mh_print_dec(0,0,fps,RGB_WHITE);
#ifdef SOUND
        dbgSound();
#endif // SOUND
#ifdef CDEMULATION
        dbgCDPlay();
#endif//CDEMULATION
    }


}

//-----------------------------------------------------------------------------
// CPU bitblt
//-----------------------------------------------------------------------------
void blt_normal(int x,int y,int w,int h)
{
    register int sx = (SCREEN_WIDTH - w)/2;
    register int sy = (SCREEN_HEIGHT- h)/2;
    register int i,j;

    for(j=0;j<h;j++) {
        register DWORD* dst = (DWORD*)pgGetVramAddr(sx,sy+j);
        register DWORD* src = (DWORD*)&XBuf[WIDTH*(j+y)+x];
        for(i=0;i<w/2;i++) {
            *dst++ = *src++;
        }
    }

    image_debug();
    image_flip();
}


#ifdef GPU_ENABLE
//-----------------------------------------------------------------------------
// GPU֘A
//-----------------------------------------------------------------------------
static int   gpu_cbid=-1; // callback id
static int   gpu_sig_finish=1;
static int   gpu_sig_signal=0;
static int   gpu_qid=-1;
static int   gpu_back=0;


void gpu_fill_finish(int id,void *pSig);

struct {
    void (*psigfunc)(int,void*); // gpusignal荞݂ZbgƗH
    void * psig;
    void (*pfinfunc)(int,void*);
    void * pfin;
} gpu_cb_param = {
    gpu_fill_finish, 
    &gpu_sig_signal,
    gpu_fill_finish,
    &gpu_sig_finish
  };

//
void gpu_fill_finish(int id, void *pSig)
{
    if(pSig==&gpu_sig_finish) {
        sceGeListSync(gpu_qid,0);
        gpu_qid = -1;
        //image_debug();
        //image_flip();
    }
}

// 
void blt_gpu_init(void)
{
#ifdef CALLBACK_ENABLE
    if(gpu_cbid==-1) {
        gpu_cbid = sceGeSetCallback(&gpu_cb_param);
    }
#endif
}

unsigned int GEcmd[16];
short ScreenVertex[10] __attribute__((aligned(64))) =  {
    //0  1  2  3  4    5    6    7    8  9
    0, 0, 0, 0, 0, 256, 224, 480, 272, 0
  };


//-----------------------------------------------------------------------------
// GPU bitblt
//-----------------------------------------------------------------------------
void blt_gpu(int x,int y,int w,int h)
{
    int b;
    int ScreenX,ScreenY;
    int ScreenW=w,ScreenH=h;
    unsigned short *screen = (unsigned short*)XBuf;
    //static unsigned int GEcmd[16];

#ifdef CALLBACK_ENABLE
    image_debug();
    image_flip();
#else
    if(gpu_qid>=0) {
        sceGeDrawSync(0);
        //sceGeListSync(gpu_qid,0);
        image_debug();
        image_flip();
        gpu_qid = -1;
    }
#endif

    switch(eConf.video) {
      case 2: /* 4:3 */
        ScreenW = 362;
        ScreenH = 272;
        break;
      case 3: /* FULL SCREEN */
        ScreenW = SCREEN_WIDTH;
        ScreenH = SCREEN_HEIGHT;
        break;
    }
    
    ScreenX = (SCREEN_WIDTH-ScreenW)/2;
    ScreenY = (SCREEN_HEIGHT-ScreenH)/2;
    
    // eNX`obt@̐擪AhXƏcTCY
    // Zbg鎖GPU̓obt@\𗝉łB
    // ̒ł̃|CgwGPUŐ߂ē͂B
    // [n_][I_]̊֌Wς鎖ŉ摜]
    
    ScreenVertex[0] = x;                // TextureWJJnʒu:X
    ScreenVertex[1] = y;                // TextureWJIʒu:Y
    ScreenVertex[2] = ScreenX;          // 摜WJʒu:Jn_ X
    ScreenVertex[3] = ScreenY;          // 摜WJʒu:Jn_ Y
    ScreenVertex[4] = 0;                // s
    ScreenVertex[5] = x+w;              // TextureWJIʒu:X
    ScreenVertex[6] = y+h            ;  // TextureWJIʒu:Y
    ScreenVertex[7] = ScreenX+ScreenW;  // 摜WJʒu:I_ X
    ScreenVertex[8] = ScreenY+ScreenH;  // 摜WJʒu:I_ Y
    ScreenVertex[9] = 0;                // s

    // Set Draw Buffer
    GEcmd[ 0] = 0x9C000000UL | ((u32)(unsigned char *)pgGetVramAddr(0,0) & 0x00FFFFFF);
    GEcmd[ 1] = 0x9D000000UL | (((u32)(unsigned char *)pgGetVramAddr(0,0) & 0xFF000000) >> 8) | 512;
    // Set Tex Buffer
    GEcmd[ 2] = 0xA0000000UL | ((u32)(unsigned char *)screen & 0x00FFFFFF);
    GEcmd[ 3] = 0xA8000000UL | (((u32)(unsigned char *)screen & 0xFF000000) >> 8) | 512;
//    GEcmd[ 4] = 0xB8000000UL | (((h>256)?9:8)<< 8) | ((w>256)?9:8);
    GEcmd[ 4] = 0xB8000000UL | 0x0800/*HEIGHT=256(2y8)*/ | (9)/*WIDTH=512(2y9)*/;
    // Tex Flush
    GEcmd[ 5] = 0xCB000000UL;
    // Set Vertex
    GEcmd[ 6] = 0x12000000UL | (1 << 23) | (0 << 11) | (0 << 9) | (2 << 7) | (0 << 5) | (0 << 2) | 2;
    GEcmd[ 7] = 0x10000000UL;
    GEcmd[ 8] = 0x02000000UL;
    GEcmd[ 9] = 0x10000000UL | (((u32)(void *)ScreenVertex & 0xFF000000) >> 8);
    GEcmd[10] = 0x01000000UL | ( (u32)(void *)ScreenVertex & 0x00FFFFFF);
    // Draw Vertex
    GEcmd[11] = 0x04000000UL | (6 << 16) | 2;
    // List End
    GEcmd[12] = 0x0F000000UL;
    GEcmd[13] = 0x0C000000UL;
    GEcmd[14] = 0;

    // I[o[wbh̓zghȂ
    // (CPU`̎ɂĂxωȂ)
    sceKernelDcacheWritebackAll();
    
#if 1
    gpu_cbid = -1;
    gpu_qid = sceGeListEnQueue(&GEcmd[0],&GEcmd[14],gpu_cbid,NULL);
    gpu_back = 1-gpu_back;
    XBuf = img_buffer[gpu_back];
#else
    gpu_qid = sceGeListEnQueue(&GEcmd[0],&GEcmd[14],-1,NULL);
    b = sceGeListSync(gpu_qid,0);
    image_debug();
    mh_print_hex8(0,10,gpu_qid,-1);
    mh_print_hex8(0,20,b,-1);
    image_flip();
#endif
}
#endif//GPU_ENABLE

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void image_config_update(void)
{
#ifndef GPU_ENABLE
    img_buffer[0] = xbuf1;
    XBuf = img_buffer[0];
    eConf.video = 0;
#else
    if(!pgPSP()) eConf.video=0;
    
    if(eConf.video==0) {
        img_buffer[0] = xbuf1;
        img_buffer[1] = xbuf1;
        
        XBuf = img_buffer[0];
        PutImage = blt_normal;
    } else {
        img_buffer[0] = 0x04100000; // eDRAM
        img_buffer[1] = 0x04140000; // eDRAM
        blt_gpu_init();
        gpu_back=0;
        XBuf = img_buffer[gpu_back];
        PutImage = blt_gpu;
    }
#endif
}

//-----------------------------------------------------------------------------
// image clear
//-----------------------------------------------------------------------------
void ClearImage(void)
{
    //_memset(xbuf,0,sizeof(PALFMT)*WIDTH*HEIGHT);
//    _memset(xbuf,0,sizeof(xbuf));
}

// initialize
void InitImage(void)
{
    //ClearImage();
    //XBuf = xbuf;
}
